/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.GlaiveRush;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class GlaiveRushLock
extends StatusBase {
    private transient PixelmonWrapper target;

    public GlaiveRushLock() {
        super(StatusType.GlaiveRush);
    }

    public GlaiveRushLock(PixelmonWrapper target) {
        super(StatusType.GlaiveRush);
        this.target = target;
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (target == this.target) {
            return new int[]{power * 2, -2};
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        if (!attack.getMove().hasEffect(GlaiveRush.class)) {
            user.removeStatus(this);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        int accuracy;
        if (userChoice.hitsAlly()) {
            return;
        }
        MoveChoice maxAccuracyChoice = null;
        for (MoveChoice choice : bestUserChoices) {
            if (maxAccuracyChoice != null && maxAccuracyChoice.result.accuracy >= choice.result.accuracy) continue;
            maxAccuracyChoice = choice;
        }
        if (maxAccuracyChoice != null && (accuracy = maxAccuracyChoice.result.accuracy) < 100 && accuracy > 0) {
            userChoice.raiseWeight(100 - maxAccuracyChoice.result.accuracy);
            userChoice.raiseTier(maxAccuracyChoice.tier);
        }
    }
}

