/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.eventbus.api.Event;

public class TrainerParticipant
extends BattleParticipant {
    public NPCTrainer trainer;

    public TrainerParticipant(NPCTrainer trainer, PlayerEntity opponent, int numPokemon) throws IllegalStateException {
        super(numPokemon);
        this.setTrainer(trainer, opponent);
    }

    public TrainerParticipant(NPCTrainer trainer, PlayerEntity opponent, int numPokemon, List<Pokemon> teamSelection) throws IllegalStateException {
        super(numPokemon);
        this.setTrainer(trainer, opponent);
        this.loadParty(teamSelection);
    }

    private void setTrainer(NPCTrainer trainer, PlayerEntity opponent) throws IllegalStateException {
        if (!trainer.canStartBattle(opponent, true)) {
            throw new IllegalStateException("NPC Trainer already battled: " + trainer.func_200200_C_());
        }
        this.trainer = trainer;
        this.loadParty(trainer.getPokemonStorage());
    }

    public TrainerParticipant(NPCTrainer trainer, int numPokemon) throws IllegalStateException {
        super(numPokemon);
        if (trainer.battleController != null) {
            throw new IllegalStateException("NPC Trainer already battled: " + trainer.func_200200_C_());
        }
        this.trainer = trainer;
        this.loadParty(trainer.getPokemonStorage());
    }

    @Override
    public void startBattle() {
        this.controlledPokemon.clear();
        this.trainer.setBattleController(this.bc);
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.bc = this.bc;
            if (pw.entity == null) continue;
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
            pw.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
            pw.entity.func_184646_p(0.0f);
            pw.entity.func_191989_p(0.0f);
            pw.entity.func_70657_f(0.0f);
            pw.entity.field_70160_al = true;
            pw.entity.func_70661_as().func_75499_g();
        }
        if (this.trainer.getBossTier().isBoss()) {
            int lvl = 1;
            for (BattleParticipant p : this.bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                lvl = Math.max(lvl, ((PlayerParticipant)p).getHighestLevel());
            }
            lvl = (int)((double)lvl * this.trainer.getBossTier().getLevelMultiplier());
            lvl += this.trainer.getBossTier().getExtraLevels();
            PixelmonWrapper[] pixelmonWrapperArray = this.allPokemon;
            int n = pixelmonWrapperArray.length;
            for (int pw = 0; pw < n; ++pw) {
                PixelmonWrapper pw2 = pixelmonWrapperArray[pw];
                pw2.bc = this.bc;
                pw2.setTempLevel(lvl);
            }
        }
        this.setPokemonInBattle();
        for (PixelmonWrapper pw : this.allPokemon) {
            if (!pw.onBattlefield) continue;
            this.controlledPokemon.add(pw);
        }
        if (!Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon))) {
            for (PixelmonWrapper pw : this.controlledPokemon) {
                pw.entity = this.trainer.releasePokemon(pw.getPokemonUUID());
                if (pw.entity == null) continue;
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
                pw.entity.func_184646_p(0.0f);
                pw.entity.func_191989_p(0.0f);
                pw.entity.func_70657_f(0.0f);
                pw.entity.field_70160_al = true;
                pw.entity.func_70661_as().func_75499_g();
                pw.entity.setPixelmonToFlyForBattle();
            }
            Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon, ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity));
        }
        super.startBattle();
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.setHealth(pw.getMaxHealth());
            pw.enableReturnHeldItem();
        }
        BattleAIMode battleAIMode = this.trainer.getBattleAIMode();
        if (battleAIMode == BattleAIMode.DEFAULT) {
            battleAIMode = PixelmonConfigProxy.getBattle().getBattleAITrainer();
        }
        this.setBattleAI(battleAIMode.createAI(this));
        this.trainer.startBattle(this.bc.getOpponents(this).get(0));
    }

    private void setPokemonInBattle() {
        for (int i = 0; i < this.numControlledPokemon; ++i) {
            if (this.allPokemon.length <= i) continue;
            if (!this.bc.isRaid()) {
                this.allPokemon[i].battlePosition = i;
            }
            this.allPokemon[i].onBattlefield = true;
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Trainer;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return this.countAblePokemon() > this.getActiveUnfaintedPokemon().size() + this.switchingOut.size();
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        if (this.trainer.battleController != null && this.trainer.battleController.participants != null) {
            ArrayList opponents = (ArrayList)this.trainer.battleController.participants.stream().filter(p -> p.team != this.team).collect(Collectors.toList());
            if (this.hasMorePokemon() || opponents.stream().noneMatch(BattleParticipant::hasMorePokemon)) {
                this.trainer.winBattle(opponents);
            } else {
                this.trainer.loseBattle(opponents);
            }
            if (!this.trainer.canEngage) {
                this.trainer.func_70106_y();
                this.trainer.unloadEntity();
            }
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetOnSwitch();
            pw.getBattleStats().clearBattleStats();
            pw.clearStatus();
            pw.resetBattleEvolution();
            if (pw.entity == null) continue;
            pw.entity.onEndBattle();
            this.retrieveEntityDuringBattleUnlessRiding(pw);
        }
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.resetBattleEvolution();
            pw.writeToNBT();
        }
        this.trainer.setAttackTargetPix(null);
        this.trainer.healAllPokemon();
        this.trainer.restoreAllFriendship();
        this.trainer.setBattleController(null);
    }

    @Override
    public void getNextPokemon(int position) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.battlePosition != position) continue;
            this.bc.switchPokemon(pw.getPokemonUUID(), this.getBattleAI().getNextSwitch(pw), true);
            return;
        }
    }

    @Override
    public UUID getNextPokemonUUID() {
        return this.trainer.getNextPokemonUUID();
    }

    private String getTranslatedName() {
        String loc = null;
        if (this.bc != null) {
            for (BattleParticipant p : this.bc.getOpponents(this)) {
                if (!(p instanceof PlayerParticipant)) continue;
                loc = ((ServerPlayerEntity)p.getEntity()).getLanguage();
            }
        }
        if (loc == null) {
            return this.trainer.func_200200_C_().getString();
        }
        return this.trainer.getName(loc);
    }

    @Override
    public TextComponent getName() {
        return new StringTextComponent(this.getTranslatedName());
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper p) {
        return this.getBattleAI().getNextMove(p);
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper oldPokemon, UUID newPixelmonUUID) {
        int index = oldPokemon.getControlledIndex();
        if (index == -1 && this.bc.simulateMode) {
            index = 0;
        }
        String beforeName = oldPokemon.getNickname();
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonUUID);
        oldPokemon.beforeSwitch(newWrapper);
        if (!oldPokemon.isFainted() && !oldPokemon.nextSwitchIsMove) {
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.getTranslatedName(), beforeName);
        }
        if (!this.bc.simulateMode) {
            if (oldPokemon.entity != null && (!oldPokemon.entity.hasOwner() || oldPokemon.entity.hasOwner() && !oldPokemon.entity.func_184196_w((Entity)Objects.requireNonNull(oldPokemon.entity.getOwner())))) {
                oldPokemon.entity.retrieve("SwitchInBattle");
                oldPokemon.entity = null;
            }
            if (!Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(newWrapper.pokemon))) {
                newWrapper.entity = this.trainer.releasePokemon(newPixelmonUUID);
                if (newWrapper.entity != null) {
                    newWrapper.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
                    newWrapper.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
                    newWrapper.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
                    newWrapper.entity.func_184646_p(0.0f);
                    newWrapper.entity.func_191989_p(0.0f);
                    newWrapper.entity.func_70657_f(0.0f);
                    newWrapper.entity.field_70160_al = true;
                    newWrapper.entity.func_70661_as().func_75499_g();
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(newWrapper.pokemon, newWrapper.entity));
                }
            }
        }
        if (this.trainer.getBossTier().isBoss()) {
            int lvl = 1;
            for (BattleParticipant p : this.bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                lvl = Math.max(lvl, ((PlayerParticipant)p).getHighestLevel());
            }
            lvl = (int)((double)lvl * this.trainer.getBossTier().getLevelMultiplier());
            newWrapper.setLevelNum(lvl += this.trainer.getBossTier().getExtraLevels());
        }
        this.controlledPokemon.set(index, newWrapper);
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        if (!this.bc.simulateMode) {
            this.bc.sendToOthers("pixelmon.battletext.sentout", this, this.getTranslatedName(), newWrapper.getNickname());
            this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        }
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (Pokemon pokemon : this.trainer.getPokemonStorage().getTeam()) {
            if (pokemon.getMoveset().size() != 0) continue;
            if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
                Pixelmon.LOGGER.info("Couldn't load Pok\u00e9mon's moves.");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canMegaEvolve() {
        if (this.bc != null && this.bc.isRaid()) {
            return false;
        }
        return this.dynamax == null && this.trainer.getMegaItem().canMega();
    }

    @Override
    public boolean canDynamax() {
        BattleParticipant bp;
        if (this.bc != null && this.bc.isRaid() && (bp = this.getOpponents().get(0)) instanceof RaidPixelmonParticipant) {
            RaidPixelmonParticipant rpp = (RaidPixelmonParticipant)bp;
            return rpp.canDynamax(this);
        }
        return this.evolution == null && (this.trainer.getMegaItem().canDynamax() || this.trainer.isGymLeader);
    }

    @Override
    public void updatePokemon(PixelmonWrapper p) {
    }

    public MobEntity getEntity() {
        return this.trainer.getEntity();
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public String getDisplayName() {
        return this.getTranslatedName();
    }

    @Override
    public TrainerPartyStorage getStorage() {
        return this.trainer.getPokemonStorage();
    }
}

