/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import java.util.ArrayList;
import java.util.List;

public class SwitchOut
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (userWrapper == targetWrapper) {
            this.applyEffect(userWrapper, targetWrapper);
            if (!userWrapper.nextSwitchIsMove) {
                if (userWrapper.attack.moveResult.result == AttackResult.failed) {
                    userWrapper.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                }
            } else {
                userWrapper.attack.moveResult.result = AttackResult.succeeded;
            }
        }
        return userWrapper.attack.moveResult.result;
    }

    @Override
    public void applyEffect(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper) {
        if (userWrapper.bc.simulateMode || userWrapper.inParentalBond && targetWrapper.isAlive()) {
            return;
        }
        if (userWrapper.stopsForcedSwitches(userWrapper)) {
            return;
        }
        ArrayList<PixelmonWrapper> activePokemon = userWrapper.bc.getActivePokemon();
        if (!activePokemon.contains(userWrapper) || !activePokemon.contains(targetWrapper)) {
            return;
        }
        BattleParticipant userParticipant = userWrapper.getParticipant();
        if (!userParticipant.hasMorePokemonReserve() || targetWrapper.isFainted() && targetWrapper.getParticipant().countAblePokemon() == 0) {
            return;
        }
        userWrapper.nextSwitchIsMove = true;
        if (userParticipant instanceof TrainerParticipant) {
            userWrapper.bc.switchPokemon(userWrapper.getPokemonUUID(), userWrapper.getBattleAI().getNextSwitch(userWrapper), true);
        } else if (userParticipant instanceof PlayerParticipant) {
            if (userParticipant.hasMorePokemonReserve()) {
                int i;
                boolean pursuitAttacker = false;
                int j = i = userWrapper.bc.turnList.size() - 1;
                while (i >= 0) {
                    PixelmonWrapper queuedPokemon = userWrapper.bc.turnList.get(j);
                    int queuedIndex = userWrapper.bc.turnList.indexOf(queuedPokemon);
                    int userIndex = userWrapper.bc.turnList.indexOf(userWrapper);
                    if (userIndex == i) break;
                    if (queuedPokemon.attack.isAttack(AttackRegistry.PURSUIT) && queuedPokemon.targets.contains(userWrapper) && userIndex < queuedIndex) {
                        queuedPokemon.bc.turnList.remove(queuedPokemon);
                        queuedPokemon.bc.turnList.add(userWrapper.bc.turn + 1, queuedPokemon);
                        pursuitAttacker = true;
                        ++j;
                    }
                    --j;
                    --i;
                }
                if (!pursuitAttacker) {
                    userWrapper.wait = true;
                    NetworkHelper.sendPacket(new EnforcedSwitchTask(userWrapper.bc.getPositionOfPokemon(userWrapper, userWrapper.getParticipant()), userWrapper.nextSwitchIsMove), userWrapper.getPlayerOwner());
                }
            } else {
                userWrapper.nextSwitchIsMove = false;
            }
        } else {
            userWrapper.nextSwitchIsMove = false;
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, userChoice.createList())) {
            userChoice.raiseWeight(30.0f);
        }
    }
}

