/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.EarlyBird;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Hydration;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryStatusItem;
import java.util.List;

public class Rest
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        Sleep sleep = new Sleep(2);
        if (user.hasFullHealth() || user.hasStatus(StatusType.Sleep, StatusType.HealBlock) || Sleep.uproarActive(user) || user.cannotHaveStatus(sleep, user, true)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        user.removePrimaryStatus(false);
        user.addStatus(sleep, user);
        user.healEntityBy(user.getMaxHealth());
        user.bc.sendToAll("pixelmon.effect.healthsleep", user.getNickname());
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        userChoice.raiseWeight(100.0f - pw.getHealthPercent());
        if (pw.hasNonVolatileStatus(false)) {
            userChoice.raiseWeight(30.0f);
        }
        Ability ability = pw.getBattleAbility();
        HeldItem heldItem = pw.getUsableHeldItem();
        if (!(pw.getMoveset().hasAttack(AttackRegistry.SLEEP_TALK, AttackRegistry.SNORE) || ability instanceof EarlyBird || ability instanceof Hydration && pw.bc.globalStatusController.hasStatus(StatusType.Rainy))) {
            BerryStatusItem berry;
            if (heldItem instanceof BerryStatusItem && (berry = (BerryStatusItem)heldItem).canHealStatus(StatusType.Sleep)) {
                return;
            }
            if (MoveChoice.canKOFromFull(bestOpponentChoices, pw, 3)) {
                userChoice.lowerTier(1);
            }
            userChoice.weight /= 2.0f;
        }
    }
}

