/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Chlorophyll;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Drizzle;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Drought;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Moody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandRush;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandStream;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandVeil;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ShadowTag;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SnowCloak;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SnowWarning;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SwiftSwim;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.AbilityClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.AbilityComboClauseLogicalOr;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.ItemPreventClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.LogicalAndBattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.LogicalOrBattleClauseSingle;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.MaximumOneBatonPass;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.MoveClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.MultipleSpeciesClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.NoDuplicateItemClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.PokemonBanClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.SkyBattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.SpeedPassClause;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelection;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class BattleClauseRegistry {
    private static final Map<String, BattleClause> REGISTERED_CLAUSES = Maps.newConcurrentMap();
    private static final Function<String, BattleClause> DEFAULT_GETTER = BattleClause::new;
    public static final BattleClause BAG_CLAUSE = BattleClauseRegistry.register(new BattleClause("bag"));
    public static final BattleClause BATON_PASS_CLAUSE = BattleClauseRegistry.register(new MoveClause("batonpass", true, AttackRegistry.BATON_PASS));
    public static final BattleClause MAX_ONE_BATON_PASS = BattleClauseRegistry.register(new MaximumOneBatonPass());
    public static final BattleClause CHATTER = BattleClauseRegistry.register(new MoveClause("chatter", true, AttackRegistry.CHATTER));
    public static final BattleClause DRIZZLE = BattleClauseRegistry.register(new AbilityClause("drizzle", Drizzle.class));
    public static final BattleClause DRIZZLE_SWIM = BattleClauseRegistry.register(new AbilityComboClauseLogicalOr("drizzleswim", Drizzle.class, SwiftSwim.class));
    public static final BattleClause DROUGHT = BattleClauseRegistry.register(new AbilityClause("drought", Drought.class));
    public static final BattleClause ENDLESS_BATTLE = BattleClauseRegistry.register(new LogicalOrBattleClauseSingle("endlessbattle", new ItemPreventClause("", EnumHeldItems.leppa), new MoveClause("", true, AttackRegistry.RECYCLE), new MoveClause("", true, AttackRegistry.FLING, AttackRegistry.HEAL_PULSE, AttackRegistry.PAIN_SPLIT)));
    public static final BattleClause EVASION_ABILITY = BattleClauseRegistry.register(new AbilityClause("evasionability", SandVeil.class, SnowCloak.class));
    public static final BattleClause EVASION = BattleClauseRegistry.register(new MoveClause("evasion", true, AttackRegistry.DOUBLE_TEAM, AttackRegistry.MINIMIZE));
    public static final BattleClause FORFEIT_CLAUSE = BattleClauseRegistry.register(new BattleClause("forfeit"));
    public static final BattleClause INVERSE_BATTLE = BattleClauseRegistry.register(new BattleClause("inverse"));
    public static final BattleClause NO_DUPLICATE_ITEMS = BattleClauseRegistry.register(new NoDuplicateItemClause());
    public static final BattleClause LEGEND_BAN = BattleClauseRegistry.register(new PokemonBanClause("legendary", (Species[])PixelmonSpecies.getLegendaries().stream().map(PixelmonSpecies::fromNationalDex).toArray(Species[]::new)));
    public static final BattleClause MEGA_STONE = BattleClauseRegistry.register(new ItemPreventClause("mega", EnumHeldItems.megaStone));
    public static final BattleClause MOODY = BattleClauseRegistry.register(new AbilityClause("moody", Moody.class));
    public static final BattleClause OHKO = BattleClauseRegistry.register(new MoveClause("ohko", true, AttackRegistry.FISSURE, AttackRegistry.GUILLOTINE, AttackRegistry.HORN_DRILL, AttackRegistry.SHEER_COLD));
    public static final BattleClause SAND_STREAM = BattleClauseRegistry.register(new AbilityClause("sandstream", SandStream.class));
    public static final BattleClause SHADOW_TAG = BattleClauseRegistry.register(new AbilityClause("shadowtag", ShadowTag.class));
    public static final BattleClause SKY_BATTLE = BattleClauseRegistry.register(new SkyBattleClause());
    public static final BattleClause SLEEP_CLAUSE = BattleClauseRegistry.register(new BattleClause("sleep"));
    public static final BattleClause SMASH_PASS = BattleClauseRegistry.register(new LogicalOrBattleClauseSingle("smashpass", BATON_PASS_CLAUSE, new MoveClause("", true, AttackRegistry.SHELL_SMASH)));
    public static final BattleClause SNOW_WARNING = BattleClauseRegistry.register(new AbilityClause("snowwarning", SnowWarning.class));
    public static final BattleClause SOUL_DEW = BattleClauseRegistry.register(new LogicalOrBattleClauseSingle("souldew", new PokemonBanClause("", PixelmonSpecies.LATIAS.getValueUnsafe(), PixelmonSpecies.LATIOS.getValueUnsafe()), new ItemPreventClause("", EnumHeldItems.soulDew)));
    public static final BattleClause MULTIPLE_SPECIES = BattleClauseRegistry.register(new MultipleSpeciesClause());
    public static final BattleClause SPEED_PASS = BattleClauseRegistry.register(new SpeedPassClause());
    public static final BattleClause SWAGGER = BattleClauseRegistry.register(new MoveClause("swagger", true, AttackRegistry.SWAGGER));
    public static final BattleClause WEATHER_SPEED = BattleClauseRegistry.register(new LogicalAndBattleClause("weatherspeed", DRIZZLE_SWIM, new AbilityComboClauseLogicalOr("", Drought.class, Chlorophyll.class), new AbilityComboClauseLogicalOr("", SandStream.class, SandRush.class)));

    public static BattleClause getClause(String id) {
        return REGISTERED_CLAUSES.getOrDefault(id, DEFAULT_GETTER.apply(id));
    }

    public static boolean hasClause(String id) {
        return REGISTERED_CLAUSES.containsKey(id.toLowerCase(Locale.ROOT));
    }

    public static <T extends BattleClause> T register(T newClause) {
        String newClauseID = newClause.getID();
        if (newClauseID == null || newClauseID.isEmpty()) {
            throw new IllegalArgumentException("Clause must have a key to be registered.");
        }
        if (BattleClauseRegistry.hasClause(newClauseID)) {
            throw new IllegalArgumentException("Clause is already registered: " + newClauseID);
        }
        for (String reserved : TeamSelection.getReservedKeys()) {
            if (!reserved.equals(newClauseID)) continue;
            throw new IllegalArgumentException("Clause cannot used reserved ID: " + reserved);
        }
        REGISTERED_CLAUSES.put(newClauseID, newClause);
        return newClause;
    }

    public static List<BattleClause> getClauseList() {
        ArrayList clauseList = Lists.newArrayList(REGISTERED_CLAUSES.values());
        Collections.sort(clauseList);
        return clauseList;
    }
}

