/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;

public class ResourceLocationHelper {
    public static ResourceLocation of(String resourceLocation) {
        try {
            return new ResourceLocation(resourceLocation.toLowerCase(Locale.ROOT));
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    public static ResourceLocation of(String namespace, String resourceLocation) {
        try {
            return new ResourceLocation(namespace.toLowerCase(Locale.ROOT), resourceLocation.toLowerCase(Locale.ROOT));
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    public static ResourceLocation ofTexture(String resourceLocation) {
        return ResourceLocationHelper.ofTexture(ResourceLocationHelper.of(resourceLocation));
    }

    public static ResourceLocation ofTexture(String namespace, String resourceLocation) {
        return ResourceLocationHelper.ofTexture(ResourceLocationHelper.of(namespace, resourceLocation));
    }

    public static ResourceLocation ofTexture(ResourceLocation resourceLocation) {
        if (resourceLocation.func_110623_a().startsWith("textures/")) {
            return resourceLocation;
        }
        return ResourceLocationHelper.of(resourceLocation.func_110624_b(), "textures/" + resourceLocation.func_110623_a());
    }

    public static String getFileName(ResourceLocation resourceLocation) {
        String[] args = resourceLocation.func_110623_a().split("/");
        return args[args.length - 1];
    }
}

