/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement.logic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pixelmonmod.pixelmon.api.replacement.logic.AbstractReplacementLogic;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import net.minecraft.entity.Entity;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class VillagerReplacementLogic
extends AbstractReplacementLogic {
    public VillagerReplacementLogic() {
        super("villager");
    }

    @Override
    public void replaceSpawn(EntityJoinWorldEvent event) {
        event.setCanceled(true);
        int rand = RandomHelper.getRandomNumberBetween(1, 10);
        Vector3d position = event.getEntity().func_213303_ch();
        if (rand <= 2) {
            NPCTrainer trainer = new NPCTrainer(event.getWorld());
            BaseTrainer base = ServerNPCRegistry.trainers.getRandomBaseWithData();
            trainer.setBaseTrainer(base);
            trainer.init(base);
            trainer.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            trainer.setEncounterMode(EnumEncounterMode.OncePerPlayer);
            trainer.npcLocation = SpawnLocationType.LAND_VILLAGER;
            trainer.func_110163_bv();
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> event.getWorld().func_217376_c((Entity)trainer)));
        } else {
            NPCQuestGiver npc = new NPCQuestGiver(event.getWorld());
            GeneralNPCData data = ServerNPCRegistry.villagers.getRandom();
            npc.init(data);
            npc.setCustomSteveTexture(data.getRandomTexture());
            npc.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            npc.setProfession(0);
            npc.initVilagerAI();
            npc.npcLocation = SpawnLocationType.LAND_VILLAGER;
            npc.func_110163_bv();
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> event.getWorld().func_217376_c((Entity)npc)));
        }
    }

    @Override
    public void read(Gson context, JsonElement element) {
    }
}

