/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.Palette;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PixelmonPalettes {
    public static final String NONE = "none";
    public static final String ZOMBIE = "zombie";
    public static final String SHINY = "shiny";
    public static final String ONLINE = "online";
    public static final String ALTER = "alter";
    public static final String ALIEN = "alien";
    public static final String ASHEN = "ashen";
    public static final String VALENTINE = "valentine";
    public static final String CRYSTAL = "crystal";
    public static final String DROWNED = "drowned";
    public static final String PINKAN = "pinkan";
    public static final String RAINBOW = "rainbow";
    public static final String SNOWY = "snowy";
    public static final String SPIRIT = "spirit";
    public static final String STRIKE = "strike";
    public static final String SPRING = "spring";
    public static final String SUMMER = "summer";
    public static final String AUTUMN = "autumn";
    public static final String WINTER = "winter";
    public static final String VALENCIAN = "valencian";
    public static final String REAL = "real";
    public static final String META = "meta";
    public static final String KARP = "karp";
    public static final String ROASTED = "roasted";
    public static final String SKELLY = "skelly";
    public static final String CALICO_ORANGE_WHITE = "calico_orange_white";
    public static final String CALICO_ORANGE_WHITE_BLACK = "calico_orange_white_black";
    public static final String CALICO_WHITE_ORANGE = "calico_white_orange";
    public static final String CALICO_ORANGE_GOLD = "calico_orange_gold";
    public static final String ORANGE_TWO_TONE = "orange_two_tone";
    public static final String ORANGE_ORCA = "orange_orca";
    public static final String ORANGE_DAPPLES = "orange_dapples";
    public static final String PINK_TWO_TONE = "pink_two_tone";
    public static final String PINK_ORCA = "pink_orca";
    public static final String PINK_DAPPLES = "pink_dapples";
    public static final String GRAY_BUBBLES = "gray_bubbles";
    public static final String GRAY_DIAMONDS = "gray_diamonds";
    public static final String GRAY_PATCHES = "gray_patches";
    public static final String PURPLE_BUBBLES = "purple_bubbles";
    public static final String PURPLE_DIAMONDS = "purple_diamonds";
    public static final String PURPLE_PATCHES = "purple_patches";
    public static final String APRICOT_TIGER = "apricot_tiger";
    public static final String APRICOT_ZEBRA = "apricot_zebra";
    public static final String APRICOT_STRIPES = "apricot_stripes";
    public static final String BROWN_TIGER = "brown_tiger";
    public static final String BROWN_ZEBRA = "brown_zebra";
    public static final String BROWN_STRIPES = "brown_stripes";
    public static final String ORANGE_FOREHEAD = "orange_forehead";
    public static final String ORANGE_MASK = "orange_mask";
    public static final String BLACK_FOREHEAD = "black_forehead";
    public static final String BLACK_MASK = "black_mask";
    public static final String BLUE_SAUCY = "blue_saucy";
    public static final String BLUE_RAINDROP = "blue_raindrop";
    public static final String VIOLET_SAUCY = "violet_saucy";
    public static final String VIOLET_RAINDROP = "violet_raindrop";
    public static final String POKEBALL = "pokebal";
    public static final String DUSKBALL = "duskball";
    public static final String LOVEBALL = "loveball";
    public static final String FRIENDBALL = "friendball";
    public static final String HEAVYBALL = "heavyball";
    public static final String MOONBALL = "moonball";
    public static final String PREMIERBALL = "premierball";
    public static final String MASTERBALL = "masterball";
    public static final String GSBALL = "gsball";
    public static final String IRISH = "irish";
    public static final String DIAMONDS = "diamonds";
    public static final String CLUBS = "clubs";
    public static final String MARTIAN = "martian";
    public static final String STARRY = "starry";
    public static final String YELLOW_RINGED = "yellow_ringed";
    public static final String RED_RINGED = "red_ringed";
    public static final String JUMP_ALIEN = "alien";
    public static final String COPPER_SULFATE = "copper_sulfate";
    public static final String CUPRIC_CHLORIDE = "cupric_chloride";
    public static final String LITHIUM_CHLORIDE = "lithium_chloride";
    public static final String MAGNESIUM_SULFIDE = "magnesium_sulfide";
    public static final String MANGANESE_CHLORIDE = "manganese_chloride";
    public static final String POTASSIUM_CHLORIDE = "potassium_chloride";
    public static final String SODIUM_CARBONATE = "sodium_carbonate";
    public static final String CALCIUM_CARBONATE = "calcium_carbonate";
    public static final String BUBBLES = "bubbles";
    public static final String SAUCY = "saucy";
    public static final String STRIPES = "stripes";
    public static final String CELESTIAL = "celestial";
    public static final String GOLD = "gold";
    public static final String ARCHIPELAGO = "archipelago";
    public static final String CONTINENTAL = "continental";
    public static final String ELEGANT = "elegant";
    public static final String GARDEN = "garden";
    public static final String HIGH_PLAINS = "high_plains";
    public static final String ICY_SNOW = "icy_snow";
    public static final String JUNGLE = "jungle";
    public static final String MARINE = "marine";
    public static final String MEADOW = "meadow";
    public static final String MODERN = "modern";
    public static final String MONSOON = "monsoon";
    public static final String OCEAN = "ocean";
    public static final String POLAR = "polar";
    public static final String RIVER = "river";
    public static final String SANDSTORM = "sandstorm";
    public static final String SAVANNA = "savanna";
    public static final String SUN = "sun";
    public static final String TUNDRA = "tundra";
    public static final String FANCY = "fancy";
    public static final String POKE_BALL = "poke_ball";
    public static final String VANILLA_CREAM = "vanilla_cream";
    public static final String RUBY_CREAM = "ruby_cream";
    public static final String MATCHA_CREAM = "matcha_cream";
    public static final String MINT_CREAM = "mint_cream";
    public static final String LEMON_CREAM = "lemon_cream";
    public static final String SALTED_CREAM = "salted_cream";
    public static final String RUBY_SWIRL = "ruby_swirl";
    public static final String CARAMEL_SWIRL = "caramel_swirl";
    public static final String RAINBOW_SWIRL = "rainbow_swirl";
    public static final String PRIMARY_CIRCULAR = "primary_circular";
    public static final String SECONDARY_CIRCULAR = "secondary_circular";
    public static final String DARK = "dark";
    public static final String RED_STRIPE = "red-stripe";
    public static final String BLUE_STRIPE = "blue_stripe";
    public static final String BLACK = "black";
    public static final String BLUE = "blue";
    public static final String BROWN = "brown";
    public static final String CYAN = "cyan";
    public static final String GRAY = "gray";
    public static final String GREEN = "green";
    public static final String LIGHT_GRAY = "lightgray";
    public static final String LIGHT_BLUE = "lightblue";
    public static final String WHITE = "white";
    public static final String LIME = "lime";
    public static final String MAGENTA = "magenta";
    public static final String ORANGE = "orange";
    public static final String PINK = "pink";
    public static final String PURPLE = "purple";
    public static final String RED = "red";
    public static final String YELLOW = "yellow";
    private static final Map<String, Palette> REGISTERED_PALETTES = Maps.newConcurrentMap();
    private static final Pair<String, Integer>[] CLOBBOPUS_JUMP = new Pair[]{ImmutablePair.of((Object)"none", (Object)120), ImmutablePair.of((Object)"irish", (Object)60), ImmutablePair.of((Object)"diamonds", (Object)60), ImmutablePair.of((Object)"clubs", (Object)60), ImmutablePair.of((Object)"martian", (Object)40), ImmutablePair.of((Object)"starry", (Object)40), ImmutablePair.of((Object)"yellow_ringed", (Object)20), ImmutablePair.of((Object)"red_ringed", (Object)15), ImmutablePair.of((Object)"alien", (Object)5)};
    private static final int[] CLOBBOPUS_QUALITY = new int[]{1, 2, 4, 5, 6, 8, 9};
    private static final Pair<String, Integer>[] SPHEAL_JUMP = new Pair[]{ImmutablePair.of((Object)"none", (Object)120), ImmutablePair.of((Object)"pokebal", (Object)60), ImmutablePair.of((Object)"duskball", (Object)60), ImmutablePair.of((Object)"loveball", (Object)60), ImmutablePair.of((Object)"friendball", (Object)40), ImmutablePair.of((Object)"heavyball", (Object)40), ImmutablePair.of((Object)"moonball", (Object)20), ImmutablePair.of((Object)"premierball", (Object)15), ImmutablePair.of((Object)"masterball", (Object)5), ImmutablePair.of((Object)"gsball", (Object)1)};
    private static final int[] SPHEAL_QUALITY = new int[]{1, 2, 4, 5, 6, 8, 10};
    public static final Pair<String, Integer>[] SHELLOS_JUMP = new Pair[]{ImmutablePair.of((Object)"none", (Object)240), ImmutablePair.of((Object)"bubbles", (Object)120), ImmutablePair.of((Object)"diamonds", (Object)120), ImmutablePair.of((Object)"saucy", (Object)80), ImmutablePair.of((Object)"stripes", (Object)80), ImmutablePair.of((Object)"celestial", (Object)40), ImmutablePair.of((Object)"gold", (Object)10)};
    private static final int[] SHELLOS_QUALITY = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final Pair<String, Integer>[] SLUGMA_JUMP = new Pair[]{ImmutablePair.of((Object)"none", (Object)120), ImmutablePair.of((Object)"copper_sulfate", (Object)60), ImmutablePair.of((Object)"cupric_chloride", (Object)60), ImmutablePair.of((Object)"lithium_chloride", (Object)60), ImmutablePair.of((Object)"magnesium_sulfide", (Object)40), ImmutablePair.of((Object)"manganese_chloride", (Object)40), ImmutablePair.of((Object)"potassium_chloride", (Object)20), ImmutablePair.of((Object)"sodium_carbonate", (Object)15), ImmutablePair.of((Object)"calcium_carbonate", (Object)5)};
    private static final int[] SLUGMA_QUALITY = new int[]{1, 2, 4, 5, 6, 8, 9};
    public static Pair<String, Integer>[] MAGIKARP_JUMP = new Pair[]{ImmutablePair.of((Object)"none", (Object)120), ImmutablePair.of((Object)"skelly", (Object)11), ImmutablePair.of((Object)"calico_orange_gold", (Object)9), ImmutablePair.of((Object)"calico_orange_white", (Object)38), ImmutablePair.of((Object)"calico_orange_white_black", (Object)38), ImmutablePair.of((Object)"calico_white_orange", (Object)38), ImmutablePair.of((Object)"orange_two_tone", (Object)40), ImmutablePair.of((Object)"orange_orca", (Object)10), ImmutablePair.of((Object)"orange_dapples", (Object)40), ImmutablePair.of((Object)"pink_two_tone", (Object)40), ImmutablePair.of((Object)"pink_orca", (Object)10), ImmutablePair.of((Object)"pink_dapples", (Object)40), ImmutablePair.of((Object)"gray_bubbles", (Object)40), ImmutablePair.of((Object)"gray_diamonds", (Object)40), ImmutablePair.of((Object)"gray_patches", (Object)10), ImmutablePair.of((Object)"purple_bubbles", (Object)40), ImmutablePair.of((Object)"purple_diamonds", (Object)40), ImmutablePair.of((Object)"purple_patches", (Object)10), ImmutablePair.of((Object)"apricot_tiger", (Object)11), ImmutablePair.of((Object)"apricot_zebra", (Object)40), ImmutablePair.of((Object)"apricot_stripes", (Object)40), ImmutablePair.of((Object)"brown_tiger", (Object)11), ImmutablePair.of((Object)"brown_zebra", (Object)40), ImmutablePair.of((Object)"brown_stripes", (Object)40), ImmutablePair.of((Object)"orange_forehead", (Object)35), ImmutablePair.of((Object)"orange_mask", (Object)8), ImmutablePair.of((Object)"black_forehead", (Object)35), ImmutablePair.of((Object)"black_mask", (Object)8), ImmutablePair.of((Object)"blue_saucy", (Object)32), ImmutablePair.of((Object)"blue_raindrop", (Object)8), ImmutablePair.of((Object)"violet_saucy", (Object)32), ImmutablePair.of((Object)"violet_raindrop", (Object)8), ImmutablePair.of((Object)"karp", (Object)4)};
    private static final int[] MAGIKARP_QUALITY = new int[]{6, 9, 12, 18, 24, 28, 33};

    public static Palette fromName(String name) {
        return REGISTERED_PALETTES.get(name.toLowerCase(Locale.ROOT));
    }

    public static String getJumpPalette(Species species, int quality) {
        Pair<String, Integer>[] list = null;
        int available = 0;
        if (species.is(PixelmonSpecies.SLUGMA)) {
            list = SLUGMA_JUMP;
            available = SLUGMA_QUALITY[quality];
        }
        if (species.is(PixelmonSpecies.CLOBBOPUS)) {
            list = CLOBBOPUS_JUMP;
            available = CLOBBOPUS_QUALITY[quality];
        }
        if (species.is(PixelmonSpecies.SPHEAL)) {
            list = SPHEAL_JUMP;
            available = SPHEAL_QUALITY[quality];
        }
        if (species.is(PixelmonSpecies.SHELLOS)) {
            list = SHELLOS_JUMP;
            available = SHELLOS_QUALITY[quality];
        }
        if (species.is(PixelmonSpecies.MAGIKARP)) {
            list = MAGIKARP_JUMP;
            available = MAGIKARP_QUALITY[quality];
        }
        if (list != null) {
            int randomIndex;
            double totalWeight = 0.0;
            for (int i = 0; i < available; ++i) {
                totalWeight += (double)((Integer)list[i].getRight()).intValue();
            }
            double random = Math.random() * totalWeight;
            for (randomIndex = 0; randomIndex < list.length && !((random -= (double)((Integer)list[randomIndex].getRight()).intValue()) <= 0.0); ++randomIndex) {
            }
            return (String)list[randomIndex].getLeft();
        }
        return NONE;
    }

    public static List<Palette> getAll() {
        return Lists.newArrayList(REGISTERED_PALETTES.values());
    }

    static {
        HashMap palettes = Maps.newHashMap();
        for (Species species : PixelmonSpecies.getAll()) {
            for (Stats form : species.getForms()) {
                for (Gender gender : form.getPossibleGenders()) {
                    for (PaletteProperties palette : form.getGenderProperties(gender).getPalettes()) {
                        palettes.computeIfAbsent(palette.getName().toLowerCase(Locale.ROOT), ___ -> Sets.newHashSet()).add(species);
                    }
                }
            }
        }
        for (Map.Entry entry : palettes.entrySet()) {
            REGISTERED_PALETTES.put((String)entry.getKey(), new Palette((String)entry.getKey(), (Set)entry.getValue()));
        }
    }
}

