/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class Pokerus {
    public PokerusStrain type;
    public int secondsSinceInfection = 0;
    public boolean announced = false;
    private static List<UUID> pendingRequests = new ArrayList<UUID>();

    public Pokerus(PokerusStrain type) {
        this.type = type;
    }

    public Pokerus copy() {
        Pokerus copy = new Pokerus(this.type);
        copy.secondsSinceInfection = this.secondsSinceInfection;
        copy.announced = this.announced;
        return copy;
    }

    public boolean canInfect() {
        return this.secondsSinceInfection != -1 && this.secondsSinceInfection < this.type.getDuration();
    }

    public CompoundNBT serializeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74777_a("Type", (short)this.type.ordinal());
        if (this.canInfect()) {
            nbt.func_74768_a("Spread", this.secondsSinceInfection);
        } else {
            nbt.func_82580_o("Spread");
        }
        nbt.func_74757_a("Announced", this.announced);
        return nbt;
    }

    public static Pokerus deserializeFromNBT(CompoundNBT nbt) {
        if (nbt.isEmpty()) {
            return null;
        }
        Pokerus p = new Pokerus(PokerusStrain.values()[nbt.func_74765_d("Type")]);
        p.secondsSinceInfection = nbt.func_74764_b("Spread") ? nbt.func_74762_e("Spread") : -1;
        p.announced = nbt.func_74767_n("Announced");
        return p;
    }

    public static void informPlayer(ServerPlayerEntity player) {
        if (!PixelmonConfigProxy.getGeneral().getPokerus().isInformPlayers()) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(player);
        for (Pokemon pokemon : party.getAll()) {
            Pokerus pokerus;
            if (pokemon == null || (pokerus = pokemon.getPokerus()) == null || pokerus.announced) continue;
            if (!pendingRequests.contains(player.func_110124_au())) {
                pendingRequests.add(player.func_110124_au());
            }
            pokerus.announced = true;
            pokemon.markDirty(EnumUpdateType.Pokerus);
        }
    }

    public static void onHealerClose(ServerPlayerEntity player, String npc) {
        if (PixelmonConfigProxy.getGeneral().getPokerus().isInformPlayers() && pendingRequests.contains(player.func_110124_au())) {
            pendingRequests.remove(player.func_110124_au());
            ArrayList<Dialogue> dialogues = new ArrayList<Dialogue>();
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform1").build());
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform2").build());
            dialogues.add(Dialogue.builder().setName(npc).setLocalizedText("pokerus.message.inform3").build());
            Dialogue.setPlayerDialogueData(player, dialogues, true);
        }
    }
}

