/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import java.lang.reflect.Type;

public class DimensionsTypeAdapter
implements JsonSerializer<Dimensions>,
JsonDeserializer<Dimensions> {
    public Dimensions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        double width = jsonObject.get("width").getAsDouble();
        double height = jsonObject.get("height").getAsDouble();
        double length = jsonObject.get("length").isJsonNull() ? width : jsonObject.get("length").getAsDouble();
        float eyeHeight = jsonObject.has("eyeHeight") ? jsonObject.get("eyeHeight").getAsFloat() : (float)height;
        float hoverHeight = jsonObject.has("hoverHeight") ? jsonObject.get("hoverHeight").getAsFloat() : 0.0f;
        return new Dimensions(height, width, length, eyeHeight, hoverHeight);
    }

    public JsonElement serialize(Dimensions src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("width", (Number)src.getWidth());
        object.addProperty("length", (Number)src.getLength());
        object.addProperty("height", (Number)src.getHeight());
        object.addProperty("eyeHeight", (Number)Float.valueOf(src.getEyeHeight()));
        object.addProperty("hoverHeight", (Number)Float.valueOf(src.getHoverHeight()));
        return object;
    }
}

