/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class GulpMissile
extends AbstractAbility {
    private static final transient float ONE_QUARTER = 25.0f;

    @Override
    public void postProcessAttackUserHitOrMiss(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
        if (a.getAttackCategory() != AttackCategory.STATUS && pokemon.getForm().isForm(PixelmonForms.NONE) && a.isAttack(AttackRegistry.SURF, AttackRegistry.DIVE) && !pokemon.hasStatus(StatusType.MultiTurn)) {
            if (pokemon.getHealthPercent() < 50.0f) {
                pokemon.setForm("gorging");
                pokemon.bc.sendToAll("pixelmon.abilities.gulpmissile.gorging.eat", pokemon.getNickname());
            } else {
                pokemon.setForm("gulping");
                pokemon.bc.sendToAll("pixelmon.abilities.gulpmissile.gulping.eat", pokemon.getNickname());
            }
        }
    }

    @Override
    public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (user == target) {
            return;
        }
        if (!target.getForm().isForm(PixelmonForms.NONE)) {
            if (!user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)MagicGuard.class)) {
                user.doBattleDamage(target, user.getPercentMaxHealth(25.0f), DamageTypeEnum.ABILITY);
            }
            if (target.getForm().isForm("gulping")) {
                target.bc.sendToAll("pixelmon.abilities.gulpmissile.gulping.spit", target.getNickname(), user.getNickname());
                user.getBattleStats().modifyStat(-1, BattleStatsType.DEFENSE);
            } else {
                target.bc.sendToAll("pixelmon.abilities.gulpmissile.gorging.spit", target.getNickname(), user.getNickname());
                Paralysis.paralyze(target, user, null, true);
            }
            this.revertForm(target);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.revertForm(oldPokemon);
    }

    @Override
    public void applyDynamaxEffect(PixelmonWrapper pokemon) {
        this.revertForm(pokemon);
    }

    private void revertForm(PixelmonWrapper pokemon) {
        pokemon.setForm(PixelmonForms.NONE);
    }
}

