/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class StatueEvent
extends Event {
    public final ServerPlayerEntity player;

    public StatueEvent(ServerPlayerEntity player) {
        this.player = player;
    }

    @Cancelable
    public static class DestroyStatue
    extends StatueEvent {
        public final StatueEntity statue;

        public DestroyStatue(ServerPlayerEntity player, StatueEntity statue) {
            super(player);
            this.statue = statue;
        }
    }

    @Cancelable
    public static class ModifyStatue
    extends StatueEvent {
        private StatueEntity statue;
        public final EnumStatuePacketMode changeType;
        private Object value;

        public ModifyStatue(ServerPlayerEntity player, StatueEntity statue, EnumStatuePacketMode changeType, Object value) {
            super(player);
            this.statue = statue;
            this.changeType = changeType;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (value != null && value.getClass() == this.value.getClass()) {
                this.value = value;
            }
        }

        public StatueEntity getStatue() {
            return this.statue;
        }

        public void setStatue(StatueEntity statue) {
            if (statue != null) {
                this.statue = statue;
            }
        }
    }

    @Cancelable
    public static class CreateStatue
    extends StatueEvent {
        public final ServerWorld world;
        public final BlockPos location;
        private StatueEntity statue;

        public CreateStatue(ServerPlayerEntity player, ServerWorld world, BlockPos location, StatueEntity statue) {
            super(player);
            this.world = world;
            this.location = location;
            this.statue = statue;
        }

        public StatueEntity getStatue() {
            return this.statue;
        }

        public void setStatue(StatueEntity statue) {
            if (statue != null) {
                this.statue = statue;
            }
        }
    }
}

