/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.battles;

import com.pixelmonmod.pixelmon.battles.controller.ai.AdvancedAI;
import com.pixelmonmod.pixelmon.battles.controller.ai.AggressiveAI;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.RandomAI;
import com.pixelmonmod.pixelmon.battles.controller.ai.TacticalAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import java.util.Locale;
import net.minecraft.client.resources.I18n;

public enum BattleAIMode {
    DEFAULT,
    RANDOM,
    AGGRESSIVE,
    TACTICAL,
    ADVANCED;


    public static BattleAIMode getFromIndex(int index) {
        try {
            return BattleAIMode.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return RANDOM;
        }
    }

    public BattleAIMode getNextMode() {
        return BattleAIMode.values()[(this.ordinal() + 1) % BattleAIMode.values().length];
    }

    public BattleAIBase createAI(BattleParticipant participant) {
        switch (this) {
            case AGGRESSIVE: {
                return new AggressiveAI(participant);
            }
            case TACTICAL: {
                return new TacticalAI(participant);
            }
            case ADVANCED: {
                return new AdvancedAI(participant);
            }
        }
        return new RandomAI(participant);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("enum.battleAI." + this.toString().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
    }
}

