/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.attackAnimations;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayBattleParticleSystemPacket;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class VariableParticleEffect {
    public World dimension;
    public AttackAnimationData effectData;
    public int startEntityID = -1;
    public Vector3d startPos = new Vector3d(0.0, 0.0, 0.0);
    public int endEntityID = -1;
    public Vector3d endPos = new Vector3d(0.0, 0.0, 0.0);
    public ImmutableAttack immutableAttack = AttackRegistry.getAttackBaseFromEnglishName("Tackle").get();

    public VariableParticleEffect(World dimension, AttackAnimationData effectData) {
        this.dimension = dimension;
        this.effectData = effectData;
    }

    public VariableParticleEffect setStartPosition(LivingEntity entity) {
        this.startEntityID = entity.func_145782_y();
        this.startPos = entity.func_213303_ch().func_178787_e(new Vector3d(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0));
        return this;
    }

    public VariableParticleEffect setStartPosition(Vector3d vec) {
        this.startPos = vec;
        return this;
    }

    public VariableParticleEffect setEndPosition(LivingEntity entity) {
        this.endEntityID = entity.func_145782_y();
        this.endPos = entity.func_213303_ch();
        return this;
    }

    public VariableParticleEffect setEndPosition(Vector3d vec) {
        this.endPos = vec;
        return this;
    }

    public VariableParticleEffect setAttackBase(ImmutableAttack immutableAttack) {
        this.immutableAttack = immutableAttack;
        return this;
    }

    private PlayBattleParticleSystemPacket makePacket() {
        return new PlayBattleParticleSystemPacket(this.dimension, this.effectData, this.immutableAttack, this.startEntityID, this.startPos, this.endEntityID, this.endPos);
    }

    public void showTo(ServerPlayerEntity ... players) {
        PlayBattleParticleSystemPacket packet = this.makePacket();
        for (ServerPlayerEntity player : players) {
            NetworkHelper.sendPacket(player, packet);
        }
    }

    public void showAllWithin(int range) {
        Vector3d use = this.startPos == Vector3d.field_186680_a ? this.endPos : this.startPos;
        PlayBattleParticleSystemPacket packet = this.makePacket();
        NetworkHelper.sendNearbyPacket(new PacketDistributor.TargetPoint(use.field_72450_a, use.field_72448_b, use.field_72449_c, (double)range, this.dimension.func_234923_W_()), packet);
    }
}

