/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.attackAnimations;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayBattleParticleSystemPacket;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AttackAnimation {
    public transient int ticks = -1;
    public transient RegistryKey<World> dimension = null;
    public transient int startID;
    public transient PixelmonWrapper user;
    public transient float[] userPos;
    public transient int endID;
    public transient PixelmonWrapper target;
    public transient float[] targetPos;
    public transient Attack attack;
    public transient Element effectiveType;

    public AttackAnimation instantiate(PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        try {
            AttackAnimation animation = (AttackAnimation)this.getClass().newInstance();
            for (Field f : animation.getClass().getFields()) {
                if (Modifier.isTransient(f.getModifiers())) continue;
                f.set(animation, f.get(this));
            }
            animation.initialize(user, target, attack);
            animation.tickAnimation(++animation.ticks);
            return animation;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initialize(PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        this.user = user;
        this.target = target;
        this.attack = attack;
        this.effectiveType = attack.getMove().getAttackType();
        if (user.entity == null || target.entity == null) {
            return;
        }
        this.dimension = user.entity.field_70170_p.func_234923_W_();
        this.startID = user.entity.func_145782_y();
        this.userPos = new float[]{(float)user.entity.func_226277_ct_(), (float)user.entity.func_226278_cu_(), (float)user.entity.func_226281_cx_()};
        this.endID = target.entity.func_145782_y();
        this.targetPos = new float[]{(float)target.entity.func_226277_ct_(), (float)target.entity.func_226278_cu_(), (float)target.entity.func_226281_cx_()};
    }

    public abstract boolean tickAnimation(int var1);

    public abstract boolean usedOncePerTurn();

    public void sendBattleEffect(AttackAnimationData data, boolean groundedStartPosition, boolean groundedEndPosition) {
        try {
            PlayBattleParticleSystemPacket packet = new PlayBattleParticleSystemPacket(this, this.attack, data, groundedStartPosition, groundedEndPosition);
            if (PixelmonConfigProxy.getGraphics().isOnlyShowAttackEffectsToBattlers()) {
                this.user.bc.spectators.forEach(spectator -> NetworkHelper.sendPacket(spectator.getEntity(), packet));
                this.user.bc.getPlayers().forEach(pp -> {
                    if (pp.player != null) {
                        NetworkHelper.sendPacket(pp.player, packet);
                    }
                });
            } else {
                RegistryKey dim = this.user.getParticipant().getEntity().field_70170_p.func_234923_W_();
                double x = this.user.getParticipant().getEntity().func_226277_ct_();
                double y = this.user.getParticipant().getEntity().func_226278_cu_();
                double z = this.user.getParticipant().getEntity().func_226281_cx_();
                NetworkHelper.sendNearbyPacket(new PacketDistributor.TargetPoint(x, y, z, (double)PixelmonConfigProxy.getGraphics().getRangeToDisplayAttackAnimations(), dim), packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

