/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class TargetEnvironmentGoal
extends Goal {
    public World world;
    public PixelmonEntity pickUpPixelmon;
    private static Biome OCEAN = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("ocean"));
    private static Biome RIVER = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("river"));
    private static Biome SWAMPLAND = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("swampland"));
    private static Biome FROZEN_RIVER = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("frozen_river"));
    private static Biome PLAINS = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("plains"));
    private static Biome FOREST = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("forest"));
    private static Biome FOREST_HILLS = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("forest_hills"));
    private static Biome JUNGLE = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("jungle"));
    private static Biome JUNGLE_HILLS = (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocationHelper.of("jungle_hills"));

    public TargetEnvironmentGoal(PixelmonEntity entity) {
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.pickUpPixelmon = entity;
    }

    public boolean func_75250_a() {
        if (this.pickUpPixelmon.hasOwner() && this.isCorrectBiomeForType()) {
            this.shouldSearch();
        }
        return true;
    }

    public boolean isCorrectBiomeForType() {
        Biome biome = this.world.func_226691_t_(this.pickUpPixelmon.func_233580_cy_());
        boolean boolIsCorrect = false;
        for (Element type : this.pickUpPixelmon.getForm().getTypes()) {
            if (type == Element.WATER) {
                if (biome != OCEAN && biome != RIVER && biome != SWAMPLAND && biome != FROZEN_RIVER) continue;
                boolIsCorrect = true;
                continue;
            }
            if (type == Element.NORMAL || type == Element.FIRE || type == Element.ELECTRIC) continue;
            if (type == Element.GRASS) {
                if (biome != PLAINS && biome != FOREST && biome != FOREST_HILLS && biome != JUNGLE && biome != JUNGLE_HILLS) continue;
                boolIsCorrect = true;
                continue;
            }
            if (type != Element.POISON && type != Element.FLYING && type != Element.GROUND && type != Element.BUG && type != Element.PSYCHIC && type != Element.ROCK && type != Element.FIGHTING && type != Element.DARK && type != Element.STEEL && type != Element.GHOST && type != Element.DRAGON) continue;
        }
        return boolIsCorrect;
    }

    public boolean shouldSearch() {
        int intSuccessChances = 1;
        int intTotalChances = 10;
        int rand = ServerLifecycleHooks.getCurrentServer().func_71218_a((RegistryKey)World.field_234918_g_).field_73012_v.nextInt(intTotalChances);
        this.sendPlayerMessage("aitargetenvironment.seessomething");
        return rand <= intSuccessChances;
    }

    public void sendPlayerMessage(String message) {
        ServerPlayerEntity player = (ServerPlayerEntity)this.pickUpPixelmon.getOwner();
        ChatHandler.sendChat((Entity)player, message, new Object[0]);
    }
}

