/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.tcg.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.tcg.requirement.AbstractCardRequirement;
import com.pixelmonmod.tcg.api.card.Card;
import com.pixelmonmod.tcg.api.card.CardRarity;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RarityRequirement
extends AbstractCardRequirement<CardRarity> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"rarity"});
    private CardRarity rarity;

    public RarityRequirement() {
        super(KEYS);
    }

    public RarityRequirement(CardRarity rarity) {
        this();
        this.rarity = rarity;
    }

    @Override
    public Requirement<Card, ItemStack, CardRarity> createInstance(CardRarity value) {
        return new RarityRequirement(value);
    }

    @Override
    public boolean isDataMatch(Card card) {
        return card.getBase().getRarity() == this.rarity;
    }

    @Override
    public void applyData(Card card) {
    }

    @Override
    public CardRarity getValue() {
        return this.rarity;
    }

    @Override
    public List<Requirement<Card, ItemStack, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createInstance(CardRarity.valueOf(args[1].toUpperCase())));
    }
}

