/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Map;
import java.util.Set;

public class IVsRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Map<BattleStatsType, Set<String>> KEYS_BY_STAT = Maps.newHashMap();
    private static final int DEFAULT_VALUE = 0;
    private final BattleStatsType statType;

    public IVsRequirement(BattleStatsType statType) {
        super(KEYS_BY_STAT.get(statType), 0);
        this.statType = statType;
    }

    public IVsRequirement(BattleStatsType statType, int value) {
        super(KEYS_BY_STAT.get(statType), 0, value);
        this.statType = statType;
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Integer> createInstance(Integer value) {
        return new IVsRequirement(this.statType, (int)value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getStats().getIVs().getStat(this.statType) == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.getStats().getIVs().setStat(this.statType, this.value);
    }

    static {
        KEYS_BY_STAT.put(BattleStatsType.HP, Sets.newHashSet((Object[])new String[]{"ivhp"}));
        KEYS_BY_STAT.put(BattleStatsType.ATTACK, Sets.newHashSet((Object[])new String[]{"ivattack", "ivatk"}));
        KEYS_BY_STAT.put(BattleStatsType.DEFENSE, Sets.newHashSet((Object[])new String[]{"ivdefence", "ivdefense", "ivdef"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_ATTACK, Sets.newHashSet((Object[])new String[]{"ivspecialattack", "ivspatk"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_DEFENSE, Sets.newHashSet((Object[])new String[]{"ivspecialdefence", "ivspecialdefense", "ivspdef"}));
        KEYS_BY_STAT.put(BattleStatsType.SPEED, Sets.newHashSet((Object[])new String[]{"ivspeed", "ivspd"}));
    }
}

