/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.loader;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DataSyncLock {
    private static final Map<String, AtomicBoolean> LOCK = Maps.newConcurrentMap();
    private static final Map<String, AtomicLong> TIMEOUT = Maps.newConcurrentMap();

    private static AtomicBoolean getLock(String context) {
        return LOCK.computeIfAbsent(context, key -> new AtomicBoolean(false));
    }

    private static AtomicLong getTimeout(String context) {
        return TIMEOUT.computeIfAbsent(context, key -> new AtomicLong(Long.MAX_VALUE));
    }

    public static void acquire(String context, long timeout) {
        DataSyncLock.getTimeout(context).set(System.currentTimeMillis() + timeout);
        DataSyncLock.getLock(context).set(true);
    }

    public static void release(String context) {
        DataSyncLock.getLock(context).set(false);
        DataSyncLock.getTimeout(context).set(Long.MAX_VALUE);
    }

    public static void park(String context) {
        AtomicBoolean lock = DataSyncLock.getLock(context);
        AtomicLong timeout = DataSyncLock.getTimeout(context);
        while (lock.get()) {
            if (System.currentTimeMillis() <= timeout.get()) continue;
            lock.set(false);
        }
    }
}

