/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui.profile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.sintinium.oauth.gui.profile.FakeClientPlayNetHandler;
import com.sintinium.oauth.gui.profile.FakeWorld;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;

public class FakePlayer
extends ClientPlayerEntity {
    private static FakePlayer instance;
    private ResourceLocation skin;
    private ResourceLocation cape = null;
    private String skinModel = "default";
    private final Map<UUID, PlayerData> cache = new ConcurrentHashMap<UUID, PlayerData>();

    public FakePlayer() {
        super(Minecraft.func_71410_x(), (ClientWorld)FakeWorld.getInstance(), (ClientPlayNetHandler)FakeClientPlayNetHandler.getInstance(), null, null, false, false);
        Minecraft.func_71410_x().func_152342_ad().func_152790_a(this.func_146103_bH(), (type, resourceLocation, minecraftProfileTexture) -> {
            this.skin = resourceLocation;
        }, true);
    }

    public static FakePlayer getInstance() {
        if (instance == null) {
            instance = new FakePlayer();
        }
        return instance;
    }

    public void setSkin(GameProfile profile) {
        if (profile == null) {
            this.skin = DefaultPlayerSkin.func_177335_a();
            this.cape = null;
            this.skinModel = "default";
            return;
        }
        PlayerData data = new PlayerData();
        this.cape = null;
        Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, (type, resourceLocation, minecraftProfileTexture) -> {
            if (type == MinecraftProfileTexture.Type.SKIN) {
                this.skin = resourceLocation;
                this.skinModel = minecraftProfileTexture.getMetadata("model");
                if (this.skinModel == null) {
                    this.skinModel = "default";
                }
                data.skin = this.skin;
                data.skinModel = this.skinModel;
                this.cache.put(profile.getId(), data);
            }
            if (type == MinecraftProfileTexture.Type.CAPE) {
                this.cape = resourceLocation;
                data.cape = this.cape;
            }
        }, false);
    }

    public boolean func_175148_a(PlayerModelPart p_175148_1_) {
        return true;
    }

    public ResourceLocation func_110306_p() {
        if (this.skin == null) {
            return DefaultPlayerSkin.func_177335_a();
        }
        return this.skin;
    }

    public String func_175154_l() {
        return this.skinModel;
    }

    public boolean func_175149_v() {
        return false;
    }

    public boolean func_184812_l_() {
        return true;
    }

    public boolean func_152122_n() {
        return true;
    }

    @Nullable
    public ResourceLocation func_110303_q() {
        return this.cape;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public float func_70032_d(Entity pEntity) {
        return Float.MAX_VALUE;
    }

    public double func_70068_e(Entity pEntity) {
        return 3.4028234663852886E38;
    }

    private static class PlayerData {
        private ResourceLocation skin;
        private ResourceLocation cape;
        private String skinModel;

        private PlayerData() {
        }
    }
}

