/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class PasswordFieldWidget
extends Widget
implements IRenderable,
IGuiEventListener {
    private final FontRenderer font;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    private String suggestion;
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, IReorderingProcessor> formatter = (p_195610_0_, p_195610_1_) -> IReorderingProcessor.func_242239_a((String)p_195610_0_, (Style)Style.field_240709_b_);

    public PasswordFieldWidget(FontRenderer p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, ITextComponent p_i232260_6_) {
        this(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, null, p_i232260_6_);
    }

    public PasswordFieldWidget(FontRenderer p_i232259_1_, int p_i232259_2_, int p_i232259_3_, int p_i232259_4_, int p_i232259_5_, @Nullable TextFieldWidget p_i232259_6_, ITextComponent p_i232259_7_) {
        super(p_i232259_2_, p_i232259_3_, p_i232259_4_, p_i232259_5_, p_i232259_7_);
        this.font = p_i232259_1_;
        if (p_i232259_6_ != null) {
            this.setValue(p_i232259_6_.func_146179_b());
        }
    }

    public void setResponder(Consumer<String> p_212954_1_) {
        this.responder = p_212954_1_;
    }

    public void setFormatter(BiFunction<String, Integer, IReorderingProcessor> p_195607_1_) {
        this.formatter = p_195607_1_;
    }

    public void tick() {
        ++this.frame;
    }

    protected IFormattableTextComponent func_230442_c_() {
        ITextComponent itextcomponent = this.func_230458_i_();
        return new TranslationTextComponent("gui.narrate.editBox", new Object[]{itextcomponent, this.value});
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String p_146180_1_) {
        if (this.filter.test(p_146180_1_)) {
            this.value = p_146180_1_.length() > this.maxLength ? p_146180_1_.substring(0, this.maxLength) : p_146180_1_;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(p_146180_1_);
        }
    }

    public String getHighlighted() {
        int i = this.cursorPos < this.highlightPos ? this.cursorPos : this.highlightPos;
        int j = this.cursorPos < this.highlightPos ? this.highlightPos : this.cursorPos;
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> p_200675_1_) {
        this.filter = p_200675_1_;
    }

    public void insertText(String p_146191_1_) {
        String s1;
        String s;
        int l;
        int i = this.cursorPos < this.highlightPos ? this.cursorPos : this.highlightPos;
        int j = this.cursorPos < this.highlightPos ? this.highlightPos : this.cursorPos;
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (s = SharedConstants.func_71565_a((String)p_146191_1_)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
            this.value = s1;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void onValueChange(String p_212951_1_) {
        if (this.responder != null) {
            this.responder.accept(p_212951_1_);
        }
        this.field_230696_r_ = Util.func_211177_b() + 500L;
    }

    private void deleteText(int p_212950_1_) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteChars(p_212950_1_);
        }
    }

    public void deleteWords(int p_146177_1_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(p_146177_1_) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int p_146175_1_) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(p_146175_1_);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = s;
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int p_146187_1_) {
        return this.getWordPosition(p_146187_1_, this.getCursorPosition());
    }

    private int getWordPosition(int p_146183_1_, int p_146183_2_) {
        return this.getWordPosition(p_146183_1_, p_146183_2_, true);
    }

    private int getWordPosition(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int i = p_146197_2_;
        boolean flag = p_146197_1_ < 0;
        int j = Math.abs(p_146197_1_);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (p_146197_3_ && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (p_146197_3_ && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int p_146182_1_) {
        this.moveCursorTo(this.getCursorPos(p_146182_1_));
    }

    private int getCursorPos(int p_238516_1_) {
        return Util.func_240980_a_((String)this.value, (int)this.cursorPos, (int)p_238516_1_);
    }

    public void moveCursorTo(int p_146190_1_) {
        this.setCursorPosition(p_146190_1_);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)p_231046_1_)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getHighlighted());
            return true;
        }
        if (Screen.func_231168_h_((int)p_231046_1_)) {
            if (this.isEditable) {
                this.insertText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (p_231046_1_) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.func_231173_s_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.func_231173_s_();
                }
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.func_230999_j_() && this.isEditable();
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)p_231042_1_)) {
            if (this.isEditable) {
                this.insertText(Character.toString(p_231042_1_));
            }
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        boolean flag;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = flag = p_231044_1_ >= (double)this.field_230690_l_ && p_231044_1_ < (double)(this.field_230690_l_ + this.field_230688_j_) && p_231044_3_ >= (double)this.field_230691_m_ && p_231044_3_ < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (this.canLoseFocus) {
            this.setFocus(flag);
        }
        if (this.func_230999_j_() && flag && p_231044_5_ == 0) {
            int i = MathHelper.func_76128_c((double)p_231044_1_) - this.field_230690_l_;
            if (this.bordered) {
                i -= 4;
            }
            String s = this.font.func_238412_a_(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.func_238412_a_(s, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    public void setFocus(boolean p_146195_1_) {
        super.func_230996_d_(p_146195_1_);
    }

    private String getHiddenValue() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.value.length(); ++i) {
            builder.append("*");
        }
        return builder.toString();
    }

    public void func_230431_b_(MatrixStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                int i = this.func_230999_j_() ? -1 : -6250336;
                PasswordFieldWidget.func_238467_a_((MatrixStack)p_230431_1_, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)i);
                PasswordFieldWidget.func_238467_a_((MatrixStack)p_230431_1_, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
            }
            int i2 = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String s = this.font.func_238412_a_(this.getHiddenValue().substring(this.displayPos), this.getInnerWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.func_230999_j_() && this.frame / 6 % 2 == 0 && flag;
            int l = this.bordered ? this.field_230690_l_ + 4 : this.field_230690_l_;
            int i1 = this.bordered ? this.field_230691_m_ + (this.field_230689_k_ - 8) / 2 : this.field_230691_m_;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            p_230431_1_.func_227860_a_();
            p_230431_1_.func_227862_a_(1.5f, 1.5f, 1.5f);
            p_230431_1_.func_227861_a_(0.0, 0.0, 0.0);
            l = (int)((double)l / 1.5);
            i1 = (int)((double)i1 / 1.5);
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.font.func_238407_a_(p_230431_1_, this.formatter.apply(s1, this.displayPos), (float)l, (float)i1 + 2.0f, i2);
            }
            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_230688_j_ : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.font.func_238407_a_(p_230431_1_, this.formatter.apply(s.substring(j), this.cursorPos), (float)j1, (float)i1 + 2.0f, i2);
            }
            if (!flag2 && this.suggestion != null) {
                this.font.func_238405_a_(p_230431_1_, this.suggestion, (float)(k1 - 1), (float)i1, -8355712);
            }
            p_230431_1_.func_227865_b_();
            l = (int)((double)l * 1.5);
            i1 = (int)((double)i1 * 1.5);
            k1 = (int)((double)k1 * 1.5);
            if (s.isEmpty()) {
                k1 = (int)((double)k1 / 1.5);
            }
            if (flag1) {
                if (flag2) {
                    AbstractGui.func_238467_a_((MatrixStack)p_230431_1_, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.font.func_238405_a_(p_230431_1_, "_", (float)k1, (float)i1, i2);
                }
            }
            p_230431_1_.func_227860_a_();
            p_230431_1_.func_227862_a_(1.5f, 1.5f, 1.5f);
            l = (int)((double)l / 1.5);
            i1 = (int)((double)i1 / 1.5);
            k1 = (int)((double)k1 / 1.5);
            if (k != j) {
                int l1 = l + this.font.func_78256_a(s.substring(0, k));
                this.renderHighlight(k1, i1 - 1, l1 - 1, i1 + 1 + 7);
            }
            p_230431_1_.func_227865_b_();
        }
    }

    private void renderHighlight(int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        if (p_146188_1_ < p_146188_3_) {
            int i = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i;
        }
        if (p_146188_2_ < p_146188_4_) {
            int j = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = j;
        }
        if (p_146188_3_ > this.field_230690_l_ + this.field_230688_j_) {
            p_146188_3_ = this.field_230690_l_ + this.field_230688_j_;
        }
        if (p_146188_1_ > this.field_230690_l_ + this.field_230688_j_) {
            p_146188_1_ = this.field_230690_l_ + this.field_230688_j_;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.5f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)p_146188_1_, (double)p_146188_4_, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)p_146188_3_, (double)p_146188_4_, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)p_146188_3_, (double)p_146188_2_, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)p_146188_1_, (double)p_146188_2_, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.scalef((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int p_146203_1_) {
        this.maxLength = p_146203_1_;
        if (this.value.length() > p_146203_1_) {
            this.value = this.value.substring(0, p_146203_1_);
            this.onValueChange(this.value);
        }
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setCursorPosition(int p_212422_1_) {
        this.cursorPos = MathHelper.func_76125_a((int)p_212422_1_, (int)0, (int)this.value.length());
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean p_146185_1_) {
        this.bordered = p_146185_1_;
    }

    public void setTextColor(int p_146193_1_) {
        this.textColor = p_146193_1_;
    }

    public void setTextColorUneditable(int p_146204_1_) {
        this.textColorUneditable = p_146204_1_;
    }

    public boolean func_231049_c__(boolean p_231049_1_) {
        return this.field_230694_p_ && this.isEditable ? super.func_231049_c__(p_231049_1_) : false;
    }

    public boolean func_231047_b_(double p_231047_1_, double p_231047_3_) {
        return this.field_230694_p_ && p_231047_1_ >= (double)this.field_230690_l_ && p_231047_1_ < (double)(this.field_230690_l_ + this.field_230688_j_) && p_231047_3_ >= (double)this.field_230691_m_ && p_231047_3_ < (double)(this.field_230691_m_ + this.field_230689_k_);
    }

    protected void func_230995_c_(boolean p_230995_1_) {
        if (p_230995_1_) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean p_146184_1_) {
        this.isEditable = p_146184_1_;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_230688_j_ - 8 : this.field_230688_j_;
    }

    public void setHighlightPos(int p_146199_1_) {
        int i = this.value.length();
        this.highlightPos = MathHelper.func_76125_a((int)p_146199_1_, (int)0, (int)i);
        if (this.font != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String s = this.font.func_238412_a_(this.value.substring(this.displayPos), j);
            int k = s.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.func_238413_a_(this.value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = MathHelper.func_76125_a((int)this.displayPos, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean p_146205_1_) {
        this.canLoseFocus = p_146205_1_;
    }

    public boolean isVisible() {
        return this.field_230694_p_;
    }

    public void setVisible(boolean p_146189_1_) {
        this.field_230694_p_ = p_146189_1_;
    }

    public void setSuggestion(@Nullable String p_195612_1_) {
        this.suggestion = p_195612_1_;
    }

    public int getScreenX(int p_195611_1_) {
        return p_195611_1_ > this.value.length() ? this.field_230690_l_ : this.field_230690_l_ + this.font.func_78256_a(this.value.substring(0, p_195611_1_));
    }

    public void setX(int p_212952_1_) {
        this.field_230690_l_ = p_212952_1_;
    }
}

