/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.sintinium.oauth.gui.ErrorScreen;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.gui.PasswordFieldWidget;
import com.sintinium.oauth.gui.ResponsiveButton;
import com.sintinium.oauth.gui.UsernameFieldWidget;
import com.sintinium.oauth.gui.profile.ProfileSelectionScreen;
import com.sintinium.oauth.login.LoginUtil;
import com.sintinium.oauth.profile.MojangProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import com.sintinium.oauth.profile.ProfileManager;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LoginScreen
extends OAuthScreen {
    private Button mojangLoginButton;
    private PasswordFieldWidget passwordWidget;
    private TextFieldWidget usernameWidget;
    private final AtomicReference<String> status = new AtomicReference();
    private final List<Runnable> toRun = new CopyOnWriteArrayList<Runnable>();

    public LoginScreen() {
        super((ITextComponent)new StringTextComponent("OAuth Login"));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.usernameWidget.func_146178_a();
        this.passwordWidget.tick();
        if (!this.toRun.isEmpty()) {
            for (Runnable r : this.toRun) {
                r.run();
            }
            this.toRun.clear();
        }
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.passwordWidget = new PasswordFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 20, 200, 20, (ITextComponent)new StringTextComponent("Password"));
        this.passwordWidget.setMaxLength(128);
        this.passwordWidget.setResponder(this::onEdited);
        this.usernameWidget = new UsernameFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 60, 200, 20, (ITextComponent)new StringTextComponent("Username/Email"), this.passwordWidget);
        this.func_212928_a((IGuiEventListener)this.usernameWidget);
        this.usernameWidget.func_212954_a(this::onEdited);
        this.field_230705_e_.add(this.usernameWidget);
        this.field_230705_e_.add(this.passwordWidget);
        this.mojangLoginButton = (Button)this.func_230480_a_((Widget)new ResponsiveButton(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 36, 200, 20, (ITextComponent)new StringTextComponent("Add Profile"), p_213030_1_ -> {
            Thread thread = new Thread(() -> {
                if (this.usernameWidget.func_146179_b().isEmpty()) {
                    this.toRun.add(() -> this.status.set("Missing username!"));
                } else {
                    MojangProfile profile;
                    if (this.passwordWidget.getValue().isEmpty()) {
                        ProfileManager.getInstance().addProfile(new OfflineProfile(this.usernameWidget.func_146179_b(), UUID.nameUUIDFromBytes(this.usernameWidget.func_146179_b().getBytes())));
                        this.toRun.add(() -> LoginScreen.setScreen(new ProfileSelectionScreen()));
                        return;
                    }
                    try {
                        profile = LoginUtil.tryGetMojangProfile(this.usernameWidget.func_146179_b(), this.passwordWidget.getValue());
                    }
                    catch (InvalidCredentialsException e) {
                        this.toRun.add(() -> this.status.set("Invalid username or password!"));
                        return;
                    }
                    catch (AuthenticationUnavailableException e) {
                        this.toRun.add(() -> this.status.set("You seem to be offline. Check your connection!"));
                        e.printStackTrace();
                        return;
                    }
                    catch (AuthenticationException e) {
                        this.toRun.add(() -> LoginScreen.setScreen(new ErrorScreen(false, e)));
                        e.printStackTrace();
                        return;
                    }
                    if (profile == null) {
                        this.toRun.add(() -> this.status.set("Invalid username or password!"));
                    } else {
                        LoginUtil.updateOnlineStatus();
                        ProfileManager.getInstance().addProfile(profile);
                        this.toRun.add(() -> LoginScreen.setScreen(new ProfileSelectionScreen()));
                    }
                }
            }, "Oauth mojang");
            thread.setDaemon(true);
            thread.start();
        }, this::updateLoginButton, () -> this.mojangLoginButton.func_238482_a_((ITextComponent)new StringTextComponent("Add Profile"))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 60, 200, 20, DialogTexts.field_240633_d_, p_213029_1_ -> LoginScreen.setScreen(new ProfileSelectionScreen())));
        this.cleanUp();
    }

    public void func_231152_a_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        String s = this.passwordWidget.getValue();
        String s1 = this.usernameWidget.func_146179_b();
        this.func_231158_b_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.passwordWidget.setValue(s);
        this.usernameWidget.func_146180_a(s1);
    }

    private void onEdited(String p_213028_1_) {
        this.cleanUp();
    }

    private void updateLoginButton() {
        if (this.passwordWidget.getValue().isEmpty()) {
            this.mojangLoginButton.func_238482_a_((ITextComponent)new StringTextComponent("Add Offline Profile"));
        } else {
            this.mojangLoginButton.func_238482_a_((ITextComponent)new StringTextComponent("Add Profile"));
        }
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231175_as__() {
        this.cleanUp();
        this.field_230706_i_.func_147108_a((Screen)new ProfileSelectionScreen());
    }

    private void cleanUp() {
        this.mojangLoginButton.field_230693_o_ = !this.usernameWidget.func_146179_b().isEmpty();
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        LoginScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)17, (int)0xFFFFFF);
        LoginScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)"Username/Email", (int)(this.field_230708_k_ / 2 - 100), (int)(this.field_230709_l_ / 2 - 60 - 12), (int)0xA0A0A0);
        LoginScreen.func_238476_c_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (String)"Password", (int)(this.field_230708_k_ / 2 - 100), (int)(this.field_230709_l_ / 2 - 20 - 12), (int)0xA0A0A0);
        if (this.status.get() != null) {
            LoginScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.status.get(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 20), (int)0xFF0000);
        }
        this.usernameWidget.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.passwordWidget.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

