/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.sintinium.oauth.OAuth;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.login.MicrosoftLogin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorScreen
extends OAuthScreen {
    private String message = null;
    private Throwable e = null;
    private boolean isInfo = false;

    public ErrorScreen(boolean isMs, String message) {
        super((ITextComponent)new StringTextComponent("Error logging into " + (isMs ? "Microsoft." : "Mojang.")));
        this.message = message;
        System.err.println(message);
    }

    public ErrorScreen(boolean isMs, Throwable e) {
        super((ITextComponent)new StringTextComponent("Error logging into " + (isMs ? "Microsoft." : "Mojang.")));
        this.e = e;
        e.printStackTrace();
    }

    public void setInfo() {
        this.isInfo = true;
    }

    protected void func_231160_c_() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 60, 200, 20, DialogTexts.field_240633_d_, p_onPress_1_ -> ErrorScreen.setScreen((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()))));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
    }

    public static ErrorScreen microsoftExceptionScreen(MicrosoftLogin.BaseMicrosoftLoginException e) {
        ErrorScreen screen = null;
        if (e instanceof MicrosoftLogin.NoXboxAccountException) {
            screen = new ErrorScreen(true, "This account has no Microsoft/Xbox account. Please login through minecraft.net to create one.");
        } else if (e instanceof MicrosoftLogin.BannedCountryException) {
            screen = new ErrorScreen(true, "This account is from a country where Xbox Live is not available/banned.");
        } else if (e instanceof MicrosoftLogin.UnderageAccountException) {
            screen = new ErrorScreen(true, "This account is under 18 and doesn't work with 3rd party logins.\nEither change your account's age or have an adult setup a family group.");
        } else if (e instanceof MicrosoftLogin.NoAccountFoundException) {
            screen = new ErrorScreen(true, "This account doesn't own Minecraft.\nIf you're a gamepass user make sure to login through the new launcher first.");
        } else {
            throw new IllegalStateException("Unknown MicrosoftLoginException: " + e.getClass().getName());
        }
        screen.setInfo();
        return screen;
    }

    private String getMessage() {
        String result = "";
        if (this.message != null) {
            result = this.message;
        } else if (this.e != null) {
            result = ExceptionUtils.getStackTrace((Throwable)this.e);
        } else {
            return "Error getting error message.";
        }
        return result;
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.func_230446_a_(p_230430_1_);
        if (this.isInfo) {
            ErrorScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 40), (int)0xFFFFFF);
            Iterable messages = Splitter.on((String)"\n").split((CharSequence)this.getMessage());
            int index = 0;
            for (String m : messages) {
                font.func_238405_a_(p_230430_1_, m, (float)this.field_230708_k_ / 2.0f - (float)font.func_78256_a(m) / 2.0f, (float)this.field_230709_l_ / 2.0f - 24.0f + (float)index * 12.0f, 0xFF4444);
                ++index;
            }
        } else if (this.getMessage().toLowerCase().contains("no such host is known") || this.getMessage().toLowerCase().contains("connection reset")) {
            ErrorScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 40), (int)0xFFFFFF);
            ErrorScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"The servers could be down or it could be an internet problem.", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 28), (int)0xFFFFFF);
            ErrorScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"If you believe this is a bug please create an issue at", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 12), (int)0xFFFFFF);
            ErrorScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"https://github.com/Sintinium/oauth with your latest log file.", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
        } else {
            IFormattableTextComponent github = new StringTextComponent("Please create an issue at https://github.com/Sintinium/oauth with your log file.").func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)));
            ErrorScreen.func_238471_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"An error occurred. This could be a bug.", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 40), (int)0xFFFFFF);
            ErrorScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)github, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 28), (int)0xFFFFFF);
            float scale = 0.5f;
            p_230430_1_.func_227862_a_(scale, scale, scale);
            String msg = this.getMessage();
            if (OAuth.getInstance().modContainer != null) {
                msg = "OAuth Forge v" + OAuth.getInstance().modContainer.getModInfo().getVersion().toString() + ": " + msg;
            }
            Iterable messages = Splitter.fixedLength((int)Math.round(80.0f * (1.0f / scale))).limit(12).split((CharSequence)msg);
            int index = 0;
            for (String m : messages) {
                font.func_238405_a_(p_230430_1_, m, (float)this.field_230708_k_ / 2.0f - (float)font.func_78256_a(m) / 2.0f * scale, ((float)this.field_230709_l_ / 2.0f - 16.0f) * (1.0f / scale) + (float)index * 12.0f, 0xFF4444);
                ++index;
            }
            p_230430_1_.func_227862_a_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

